{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 15:05:01 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TOptions = class(TForm)
    Panel1: TPanel;
    Label4: TLabel;
    Label3: TLabel;
    trackVolume: TTrackBar;
    trackPanning: TTrackBar;
    Bevel1: TBevel;
    Bevel2: TBevel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    procedure trackVolumeChange(Sender: TObject);
    procedure trackPanningChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Options: TOptions;

implementation

uses Unit1;

{$R *.DFM}

{-- TOptions ------------------------------------------------------------}
procedure TOptions.trackVolumeChange(Sender: TObject);
begin
   MainForm.MMWaveMixer.Volume := (TTrackBar(Sender).Position+(-400))*10;
end;

{-- TOptions ------------------------------------------------------------}
procedure TOptions.trackPanningChange(Sender: TObject);
begin
   MainForm.MMWaveMixer.Panning := (TTrackBar(Sender).Position+(-400))*10;
end;

{-- TOptions ------------------------------------------------------------}
procedure TOptions.FormCreate(Sender: TObject);
var
   i: integer;
begin
   if MainForm.MMWaveMixer.NumDevs > 0 then
   begin
      for i := 0 to MainForm.MMWaveMixer.NumDevs-1 do
      begin
         Combobox1.Items.Add(MainForm.MMWaveMixer.Devices[i].Description);
      end;
   end;
end;

{-- TOptions ------------------------------------------------------------}
procedure TOptions.FormShow(Sender: TObject);
begin
   ComboBox1.ItemIndex := MainForm.MMWaveMixer.DeviceID;
end;

end.
